/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openscience.miniJmol.AtomTypeLookup;
import org.openscience.miniJmol.ChemFile;
import org.openscience.miniJmol.ChemFrame;
import org.openscience.miniJmol.FortranFormat;
import org.openscience.miniJmol.JmolException;

public class XYZFile
extends ChemFile {
    private AtomTypeLookup atlu;

    public XYZFile(InputStream inputStream, AtomTypeLookup atomTypeLookup) throws Exception {
        this.atlu = atomTypeLookup;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 1024);
        try {
            while (true) {
                ChemFrame chemFrame = this.readFrame(bufferedReader);
                this.frames.addElement(chemFrame);
                Vector vector = chemFrame.getFrameProps();
                int n = 0;
                while (n < vector.size()) {
                    if (this.PropertyList.indexOf(vector.elementAt(n)) < 0) {
                        this.PropertyList.addElement(vector.elementAt(n));
                    }
                    ++n;
                }
                ++this.nframes;
            }
        }
        catch (JmolException jmolException) {
            return;
        }
    }

    public ChemFrame readFrame(BufferedReader bufferedReader) throws Exception {
        int n = 0;
        String string = "";
        String string2 = bufferedReader.readLine();
        if (string2 == null) {
            throw new JmolException("XYZFile.readFrame", "no more frames!");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t ,;");
        String string3 = stringTokenizer.nextToken();
        n = Integer.parseInt(string3);
        string = bufferedReader.readLine();
        System.out.println(string);
        ChemFrame chemFrame = new ChemFrame(n);
        chemFrame.setAtomTypeLookup(this.atlu);
        chemFrame.setInfo(string);
        int n2 = 0;
        while (n2 < n) {
            String string4 = bufferedReader.readLine();
            if (string4 == null) break;
            if (!string4.startsWith("#")) {
                String string5;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double[] dArray = new double[3];
                stringTokenizer = new StringTokenizer(string4, "\t ,;");
                boolean bl = false;
                boolean bl2 = false;
                int n3 = stringTokenizer.countTokens();
                switch (n3) {
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new JmolException("XYZFile.readFrame", "Not enough fields on line.");
                    }
                    case 5: {
                        bl = true;
                        break;
                    }
                    case 7: {
                        bl2 = true;
                        break;
                    }
                    case 8: {
                        bl = true;
                        bl2 = true;
                        break;
                    }
                }
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                String string8 = stringTokenizer.nextToken();
                String string9 = stringTokenizer.nextToken();
                d = FortranFormat.atof(string7);
                d2 = FortranFormat.atof(string8);
                d3 = FortranFormat.atof(string9);
                Vector vector = new Vector();
                if (bl) {
                    string5 = stringTokenizer.nextToken();
                    d4 = FortranFormat.atof(string5);
                }
                if (bl2) {
                    string5 = stringTokenizer.nextToken();
                    String string10 = stringTokenizer.nextToken();
                    String string11 = stringTokenizer.nextToken();
                    dArray[0] = FortranFormat.atof(string5);
                    dArray[1] = FortranFormat.atof(string10);
                    dArray[2] = FortranFormat.atof(string11);
                }
                if (bl || bl2) {
                    chemFrame.addPropertiedVert(string6, (float)d, (float)d2, (float)d3, vector);
                } else {
                    chemFrame.addVert(string6, (float)d, (float)d2, (float)d3);
                }
            }
            ++n2;
        }
        return chemFrame;
    }
}

